<?php
define('_VALID', true);
require 'include/config.php';
require 'include/function_global.php';
require 'include/function_smarty.php';
require 'classes/pagination.class.php';

if ( $config['photo_module'] == '0' ) {
        VRedirect::go($config['BASE_URL']. '/error/page_invalid');
}

$type			= ( $config['show_private_albums'] == '0' ) ? 'public' : NULL;
$type           = ( isset($_GET['type']) && ( $_GET['type'] == 'public' or $_GET['type'] == 'private' ) ) ? $_GET['type'] : $type;
$category       = ( isset($_GET['c']) ) ? intval($_GET['c']) : 0;
$categories     = get_categories();
$orders         = array('mr', 'mv', 'mp', 'tr', 'md', 'tf');
$order          = ( isset($_GET['o']) && in_array($_GET['o'], $orders) ) ? $_GET['o'] : 'mr';
$timeframes     = array('t', 'w', 'm', 'a');
$timeframe      = ( isset($_GET['t']) && in_array($_GET['t'], $timeframes) ) ? $_GET['t'] : 'a';

$sql_add        = NULL;
$sql_add_count  = NULL;
$title_t        = NULL;
$title_c        = NULL;
$title_o        = NULL;
$title_p        = NULL;

if ( $category ) {
    $sql_add        .= " AND a.category = '" .mysql_real_escape_string($category). "'";
    $sql_add_count  .= " AND category = '" .mysql_real_escape_string($category). "'";
    foreach ( $categories as $categ ) {
        if ( $categ['CHID'] == $category ) {
            $title_c = ' ' .$categ['name'];
            break;
        }
    }                                                
}

switch ( $timeframe ) {
    case 't':
        $title_t         = 'Todays';
        $sql_add        .= " AND DATE_FORMAT(a.adddate, '%y-%m-%d') = DATE_FORMAT(NOW(), '%y-%m-%d')";
        $sql_add_count  .= " AND DATE_FORMAT(adddate, '%y-%m-%d') = DATE_FORMAT(NOW(), '%y-%m-%d')";
        break;
    case 'w':
        $title_t         = 'This Weeks';
        $sql_add        .= " AND DATE_FORMAT(a.adddate, '%y-%u') = DATE_FORMAT(NOW(), '%y-%u')";
        $sql_add_count  .= " AND DATE_FORMAT(adddate, '%y-%u') = DATE_FORMAT(NOW(), '%y-%u')";
        break;
    case 'm':
        $title_t         = 'This Months';
        $sql_add        .= " AND DATE_FORMAT(a.adddate, '%y') = DATE_FORMAT(NOW(), '%y')";
        $sql_add_count  .= " AND DATE_FORMAT(adddate, '%y') = DATE_FORMAT(NOW(), '%y')";
        break;
}

if ( $type != '' ) {
    $title_p         = ' ' .ucfirst($type);
    $sql_add        .= " AND a.type = '" .$type. "'";
    $sql_add_count  .= " AND type = '" .$type. "'";
}

switch ( $order ) {
    case 'mr':
        $title_o  = ' Most Recent';
        $sql_add .= ' ORDER BY a.addtime DESC';
        break;
    case 'mv':
        $title_o  = ' Most Viewed';
        $sql_add .= ' ORDER BY a.total_views DESC';
        break;
    case 'mp':
        $title_o  = ' Most Photos';
        $sql_add .= ' ORDER BY a.total_photos DESC';
        break;
    case 'md':
        $title_o  = ' Most Commented';
        $sql_add .= ' ORDER BY a.total_comments DESC';
        break;
    case 'tr':
        $title_o  = ' Top Rated';
        $sql_add .= ' ORDER BY a.rate DESC';
        break;
    case 'tf':
        $title_o  = ' Top Favorites';
        $sql_add .= ' ORDER BY a.total_favorites DESC';
        break;
}

$sql            = "SELECT COUNT(AID) AS total_albums FROM albums WHERE status = '1'" .$sql_add_count;
$rsc            = $conn->execute($sql);
$total          = $rsc->fields['total_albums'];
$pagination     = new Pagination($config['albums_per_page']);
$limit          = $pagination->getLimit($total);
$sql            = "SELECT a.*, s.username FROM albums AS a, signup AS s WHERE a.status = '1' AND a.UID = s.UID" .$sql_add. " LIMIT " .$limit;
$rs             = $conn->execute($sql);
$albums         = $rs->getrows();
$page_link      = $pagination->getPagination('albums');
$start_num      = $pagination->getStartItem();
$end_num        = $pagination->getEndItem();

$title              = $title_t . $title_o . $title_c . $title_p;
$self_title         = $title. ' Free Adult Sex Tube Photo Albums - ' .$config['site_name'];
$self_description   = $title. ' Albums - ' .$config['site_name'];
$self_keywords      = $title. ' Albums ' .$config['meta_keywords'];

$smarty->assign('errors',$errors);
$smarty->assign('messages',$messages);
$smarty->assign('menu', 'albums');
$smarty->assign('submenu', '');
$smarty->assign('categories', get_categories());
$smarty->assign('category', $category);
$smarty->assign('timeframe', $timeframe);
$smarty->assign('order', $order);
$smarty->assign('type', $type);
$smarty->assign('albums_total', $total);
$smarty->assign('albums', $albums);
$smarty->assign('page_link', $page_link);
$smarty->assign('start_num', $start_num);
$smarty->assign('end_num', $end_num);
$smarty->assign('categories', $categories);
$smarty->assign('title', $title);
$smarty->assign('self_title', $self_title);
$smarty->assign('self_description', $self_description);
$smarty->assign('self_keywords', $self_keywords);
$smarty->display('header.tpl');
$smarty->display('errors.tpl');
$smarty->display('messages.tpl');
$smarty->display('albums.tpl');
$smarty->display('footer.tpl');
$smarty->gzip_encode();
?>
